Describe()

FUNCTION Describe()
    DLG(TI='Ein einfacher Photo-Betrachter', Button='#Help', Button='OK')
    TIME(Textout=$Date_Time)
    EDIT(Text=$Date_Time, Repeat=2, Right=':', Del=1, Ins='-')
    $titles = $AppDataPath & '\PhotoTitles.txt'
    $SaveLoadFile=$AppDataPath & '\PhotoSetting'
    SET($allPhotosCount=0, $baseDir=' ', $Dirs='C:\ProgramData\HicEst\PhotoDirs.txt', $find=' ', $clone=' ',
        $galleryRows = 3, $galleryCols = 3, $imgSel = '*.jpg', $photo1=0, $rand=' ', $random=0, $sdir=' ', $subs=0)
    FILE(DRive=drives, FileDELete=$Dirs, FileDELete=$Titles)
    ARRAY(CSV=drives, NewLine=',', Name=$drvMtx)

    FILE(Name=$SaveLoadFile, EXISTs=existing)
    IF(existing)
        IF(1 == MSG(T='Letzte Sitzung fortsetzen?', Icon='?', Button='YesNoCancel'))
            LOAD($SaveLoadFile, $allPhotosCount, $baseDir, $find, $galleryRows, $galleryCols, $photo1, $subs)
            $photo1 = MAX(1, $photo1 - $galleryRows * $galleryCols)
            FILE(Name=$baseDir &'\'& $imgSel, Subdirs=$subs, ListFiles=$titles, Count=$allPhotosCount)
            ShowImages()
        ENDIF
    ENDIF

    FILE(DRive=drives, FileDELete=$Dirs, FileDELete=$Titles)
    ARRAY(CSV=drives, NewLine=',', Name=$drvMtx)
    DLG(LBL='Laufwerk wählen', B=$drvMtx)
    $baseDir = $txtRC
    GetDirectory()
END

FUNCTION GetDirectory()
    Images($) = ('*.jpg', '*.jpeg', '*.png', '*.bmp', '*.gif', '*.ico', '*.wdp', '*.tiff')
    DO
        FILE(FileDELete=$Dirs, FileDELete=$Titles)  ! delete 2 files
        FILE(Dir=$baseDir, ListDirs=$Dirs, CouNT=nDirs)           ! new base dir listing
        FILE(Name=$Dirs, AppendText=$drvMtx)          ! save base dir and drives
        ARRAY(CSV=$Dirs, Name=DirMtx)

        FILE(Name=$baseDir &'\'& $imgSel, SubDirs=0, ListFiles=$Titles, Count=$allPhotosCount)
        IF($allPhotosCount == 0)
            DLG(LBL=$baseDir & '(Keine Bilder)',BG=99,X=0, B=DirMtx,  LBL='(Typ)',Y=-99,BG=99, RADio=Images,Val=$imgSel)
            $baseDir = $txtRC
        ELSE
            parent = $baseDir
            EDIT(Text=$baseDir, M1=0, R=999, L='\', M2=-1, CoPyto=parent)
            ARRAY(CSV=$Titles, Name=TitMtx)
            DLG(TI=$allPhotosCount && 'Bilder gefunden', LBL='Verzeichnis',BG=99,
                B=$baseDir, B=parent,BG=900, B=DirMtx,
                LBL='Wähle Startbild in' && $baseDir,Y=-999,BG=99, B=TitMtx)
            answer = $txtRC
            IF( INDEX(answer, '.') > 0)
                EDIT(T=answer, M1=0, R=999, L='\', M2=-1, CoPyto=dir, M1=2, R='.', M2=-1, CoPyto=filNam, M1=1, M2=999, CoPyto=ext)
                FILE(Name=answer, GetFileDir=$baseDir)
                SORT(Sort=$titles, Column=1)
                FILE(Name=$titles, Text=filNam, FoundinRow=$photo1)
                ShowImages()
            ELSE
                $baseDir = $txtRC
            ENDIF
        ENDIF
    ENDDO
END

FUNCTION ShowImages()
    SORT(Sort=$titles, Column=1)
    DO
        galleryCount = $galleryRows * $galleryCols
        ARRAY(Name=gallery, CLeaR=1)
        DO row = 1, $galleryRows
            DO col = 1, $galleryCols
                IF($random <= 0)
                    photoNr = col + $galleryCols * (row - 1) + $photo1 - 1
                ELSE
                    photoNr = CEILING(RAN($allPhotosCount))
                ENDIF
                IF(photoNr <= $allPhotosCount)
                    FILE(Name=$titles, Row=photoNr, RowToText=title)
                ENDIF
                gallery(row,col) = title
            ENDDO
        ENDDO
        SAVE($SaveLoadFile, $allPhotosCount, $baseDir, $find, $galleryRows, $galleryCols, $photo1, $subs)

        title = 'OK, nächste Bilder('   & $photo1 &   '-'   & ($photo1+galleryCount-1) &   '/'   &   $allPhotosCount &   ')'
        DLG(W=1, SLider=$photo1,W=1/$galleryCols,BG=9,MIN=0,MAX=$allPhotosCount,Left=$photo1,SIze=galleryCount,
            B=title,Y=0,X=1, B='Optionen', image=gallery,X=-9)

        IF($txtRC == 'Optionen')
            oldSubdirs = $subs
            oldFind = $find
            DLG(TItle='Optionen',
                LBL=$allPhotosCount && 'Bilder in' && dir && 'mit $find=' && $find,BG=90,
                B='Verzeichnisse',
                B='Laufwerk',
                E=$find,SYMB,
                NE=$galleryRows,SYMB,
                NE=$galleryCols,SYMB,
                NE=$photo1,SYMB,
                CHK='Zufall',Val=$rand,
                CHK='Mit Sub-Verzeichnis', Val=$sdir,
                B='Datum/Zeit in ALLE Bild-Titel des Verzeichnisses einfügen',
                B='OK',
                LBL='Rechts-Klick auf Bild öffnet Einzelbild-Dialog',
                B='Exit HicEst')
            $random = INDEX($rand, 'Zufall') > 0
            $subs = ($sdir ~ ' ;')
            IF( $txtRC == 'Datum/Zeit in ALLE Bild-Titel des Verzeichnisses einfügen')
                SetDatesAndTimes()
            ELSEIF( $txtRC == 'Verzeichnisse')
                $find = ''
                FILE(Name=$titles, Row=1, RowToText=title)
                drive = SUBSTRING(title, 1, 3)
                GetDirectory()
            ELSEIF( $txtRC == 'Laufwerk')
                $find = ''
                Describe()
            ELSEIF(($find > ' ') + (oldFind > ' '))
                FILE(fileDelete=$titles, Name=$baseDir & '\*' & $find & '*', SubDirs=$subs, ListFiles=$titles, Count=$allPhotosCount)
                IF($allPhotosCount <= 0)
                    MSG(T='Kein Bildtitel mit' && $find && 'gefunden in' && $baseDir)
                    FILE(Name=$baseDir & '\' & $imgSel, SubDirs=$subs, ListFiles=$titles, Count=$allPhotosCount)
                ENDIF
                $photo1 = 1
                ShowImages()
            ELSEIF( $txtRC == 'Exit HicEst')
                SYSTEM(Quit=1)
            ELSEIF($subs ~ oldSubDirs)
                $find = ''
                GetDirectory()
            ENDIF
        ELSEIF($C > 0)  ! Right mouse pressed.  $R, $C, and $TXT are system variables for row, column, text
            $path = $TXT
            $clone = newName
            EDIT(T=$path, M1=0, R=999, L='\', M2=0, CoPyto=dir, M1=1, R='.', M2=-1, CoPyto=oldName, M1=1, M2=999, CoPyto=ext)
            rotateTxts($) = ('rotR = 90° rechts','rotU = 180°','rotL = 90° links')
            temp = oldName
            DO
                newName = temp
                rotateTxt = ' '
                DLG(TItle='Änderung Bild-Titel',
                    E=oldName,X=0,RO=1,SYM,W=2,
                    LBL='Clone Teile des gewählten Titels:', E=$clone,ReadOnly=1,BG=99,Y=0,X=1,
                    LBL='Es kann eine|Drehung|gewählt werden',X=-9, LB=rotateTxts,H=1/8,Value=rotateTxt,BG=99,
                    E=newName,X=-9,SYM,W=2,
                    B='nichts tun',X=-9, B='ÄNDERN',
                    B='Kopiere Bild nach Verzeichnis = PhotosCopiedOn' && $Date_Time,Y=19,X=-9,W=2)
                IF(pastTxt > ' ') newName = temp && pastTxt
                IF(rotateTxt > ' ') newName = temp && SUBSTRING(rotateTxt, 0, 4)
                IF(newName == temp) EXIT
                temp = newName
            ENDDO
            newName = dir & newName & ext
            IF($TxtRC == 'ÄNDERN')
                FILE(Name=newName, EXISTs=existing)
                IF(existing == 0)
                    FILE(Name=$path, FileRenameTo=newName)
                    FILE(Name=$titles, Text=$path, FoundinRow=found, DELeteRow=found)
                    FILE(Name=$titles, Text=newName, TexttoRow=found)
                    SORT(Sort=$titles, Column=1)
                ELSE
                    MSG(T=newName && 'gibt es schon')
                ENDIF
            ELSEIF(SUBSTRING($TxtRC, 1, 4) == 'Kopiere')
                new = $AppDataPath & '\PhotosCopiedOn' && $Date_Time
                FILE(DIR=new)
                new = new & '\' & oldName & ext
                FILE(Name=$path, FileCopyToFile=new)
            ENDIF
            $photo1 = $photo1 - galleryCount
        ENDIF
        IF($photo1 > 0) $photo1 = $photo1 + galleryCount
        $photo1 = MAX(1, MIN($allPhotosCount - galleryCount + 1, $photo1))
    ENDDO
END

FUNCTION SetDatesAndTimes()
    changed = 0
    DO img = 1, $allPhotosCount
        FILE(Name=$titles, Row=img, RowToText=$path)
        IF( INDEX($path, '\20') == 0 ) ! eg .."\2024-11-01".. or .."\20241101"..
            FILE(Name=$path, GetFileName=name, GetFileDir=dir, GetImageTime=iTime)
            TIME(Pattern='MM/DD/YYYY hh:mm', Input=iTime, Pattern='YYYY-MM-DD hh-mm-', TextOut=uTime)
            IF(uTime(1) ~ ' ')
                new = dir & '\' & uTime & name
                FILE(Name=new, EXISTs=yes)
                IF(yes == 0) FILE(Name=$path, FileRenameTo=new)
                changed = changed + (yes == 0)
            ENDIF
        ENDIF
    ENDDO
    IF(changed) ShowImages()
END

#Help
Dies kleine Script läuft unter HicEst.exe für Windows.

.	Photos in einer Galerie betrachten
.	Photos nach Text im Titel finden
.	Änderung der Galerie-Größe
.	Änderung der Galerie-Größe
.	Einzelne Bilder der Galerie betrachten
.	Einzelne Bilder zoomen
.	Zufällige Auswahl
.	Unterordner ein/ausblenden
.	Drehung der Photos
.	Aufnahme Datum und Zeit
.	Titel für Bilder vergeben

Einzelbild in Schirmgröße:
.	Links-Klick auf Galeriebild
Zoom Einzelbild:
.	Rechts-Wischen auf Einzelbild
Zurück zur Galerie:
.	Links-Maus-Klick
Rechts-Maus-Klick öffnet
.	Rotiere Einzelbild:
###












